<?php

namespace TPC\QueueingBundle\Entity;

use Doctrine\ORM\EntityRepository;
use TPC\QueueingBundle\Entity\QueueData;
use TPC\QueueingBundle\Walker\SortableNullsWalker;
use Doctrine\ORM\Query;

/**
 * QueueBaseRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class QueueBaseRepository extends EntityRepository
{

    /**
     * Get the number of queue items associated with each status
     * @param String repository location
     * @return array status name => queue item count
     */
    public function getStatus($repo, $hours)
    {
        $response = array();

        if ($hours) {
            $dateTime = new \DateTime();
            $dateTime->modify('- ' . $hours . ' hour');
        } else {
            $dateTime = new \DateTime();
            $dateTime->modify('- 14 day');
        }

        $data = $this->createQueryBuilder('p')
                ->select('s.name, count(p) as total')
                ->join('p.status', 's')
                ->where('p.created >= :datetime')
                ->orwhere('p.updated >= :datetime')
                ->setParaMeter('datetime', $dateTime)
                ->groupBy('s.name')
                ->getQuery()
                ->getResult();

        foreach ($data as $item) {
            $response[$item['name']] = $item['total'];
        }

        $states = $this->getEntityManager()
                ->createQuery('SELECT p.name FROM TPCQueueingBundle:QueueStatus p')
                ->getResult();
        //Loop trough states
        foreach ($states as $state) {
            if (!isset($response[$state['name']])) {
                $response[$state['name']] = 0;
            }
        }
        ksort($response);
        return $response;
    }

    /**
     * Get the next job in the queue based on priority
     * @param String repository location
     * @return job
     */
    public function getNext($type, $limit)
    {

        return $this->createQueryBuilder('p')
                        ->select('p, s')
                        ->join('p.status', 's')
                        ->where("s.name = 'queued'")
                        ->andWhere('p.type  = :type')
                        ->orderBy('p.priority', 'DESC')
                        ->addOrderBy('p.id', 'ASC')
                        ->setParaMeter(':type', $type)
                        ->setMaxResults($limit)
                        ->getQuery()
                        ->getResult()
        ;
    }

    /**
     * Get a number of queue items in an array, newest first
     * @param String repository
     * @param int offset
     * @param int maximal amount of items returned
     * @return array queue items
     */
    public function showQueue($min, $max, $time, $status)
    {
        $data = array();

        $dateTime = new \DateTime();
        $dateTime->modify('- ' . $time . ' day');

//        $now = new \DateTime("now");

        $qb = $this->createQueryBuilder('p');
        $qb->join('p.status', 's');

//        $qb->addSelect('p.identifier');
//        $qb->addSelect('p.message');
//        $qb->addSelect('p.status');
//        $qb->addSelect('coalesce (p.updated, :now) as updated')->setParameter('now', $now);
//        $qb->addSelect('p.created');

        if ($status !== "all states") {
            $qb->andWhere('(p.updated >= :datetime OR p.created >= :datetime) and s.name = :status')
                    ->setParameter(':status', $status);
        } else {
            $qb->andWhere('(p.updated >= :datetime OR p.created >= :datetime)');
        }
        $result = $qb
                        ->setParaMeter('datetime', $dateTime)
                        ->addOrderBy('p.updated', 'DESC')
                        ->addOrderBy('p.created', 'DESC')
                        ->setFirstResult($min)
                        ->setMaxResults($max)
                        ->getQuery()
                        ->setHint(Query::HINT_CUSTOM_OUTPUT_WALKER, '\TPC\QueueingBundle\Walker\SortableNullsWalker')
                        ->setHint('SortableNullsWalker.fields', array(
                            'sortOrder' => SortableNullsWalker::NULLS_LAST
                        ))->getResult();

        $states = $this->createQueryBuilder('p')
                ->select('s.name, count(p) as total')
                ->join('p.status', 's')
                ->where('p.created >= :datetime')
                ->orwhere('p.updated >= :datetime')
                ->setParaMeter('datetime', $dateTime)
                ->groupBy('s.name')
                ->getQuery()
                ->getResult();

        $total = 0;
        foreach ($states as $item) {
            $data['states'][$item['name']] = $item['total'];
            $total += $item['total'];
        }
        $data['states']['total'] = $total;

        /**
         * sort by updated if the field exists, otherwise use the created field
         */
//        usort($result, function($a, $b) {
//                    if ($a->getUpdated()) {
//                        $temp1 = $a->getUpdated();
//                    } else {
//                        $temp1 = $a->getCreated();
//                    }
//
//                    if ($b->getUpdated()) {
//                        $temp2 = $b->getUpdated();
//                    } else {
//                        $temp2 = $b->getCreated();
//                    }
//
//                    return ($temp1 > $temp2) ? -1 : 1;
//                });

        foreach ($result as $queueItem) {

            $data['jobs'][] = array(
                'identifier' => $queueItem->getIdentifier(),
                'message' => $queueItem->getMessage(),
                'status' => $queueItem->getStatus()->getName(),
                'created' => $queueItem->getCreated(),
                'updated' => $queueItem->getUpdated(),
                'priority' => $queueItem->getPriority(),
            );
        }

        return $data;
    }

    /**
     * Count the number of jobs in busy state
     * @param String repository
     * @return int number of busy jobs
     */
    public function countBusy($repo, $type)
    {
        //Get all busy jobs
        $result = $this->getEntityManager()
                ->createQuery('SELECT p, s FROM ' . $repo . ' p JOIN p.status s WHERE s.name = ?1 AND p.type = ?2')
                ->setParaMeter(1, 'busy')
                ->setParaMeter(2, $type)
                ->getResult();
        //count busy jobs
        return count($result);
    }

    /**
     * Count the number of jobs in busy state
     * @return busy jobs
     */
    public function getBusy()
    {
        $result = $this
                ->createQueryBuilder('p')
                ->select('p, s')
                ->join('p.status', 's')
                ->where("s.name = 'busy'")
                ->getQuery()
                ->getResult()
        ;

        if ($result) {
            //return  busy jobs
            return $result;
        } else {
            return false;
        }
    }

    public function addQueueData($job, $key, $value)
    {
        $em = $this->getEntityManager();

        $data = new QueueData();
        $data->setBasequeueId($job->getId());
        $data->setKey($key);
        $data->setValue($value);

        $em->persist($data);
        $em->flush();

        return true;
    }

    public function getQueueData($job)
    {
        $result = $this->getEntityManager()
                ->createQuery('SELECT p FROM TPCQueueingBundle:QueueData p WHERE p.basequeueId = ?1')
                ->setParaMeter(1, $job->getId())
                ->getResult();

        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

}
