<?php

namespace TPC\QueueingBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;

class RestQueueController extends Controller
{

    /**
     * Validate and add a new job to the queue
     * @return \Symfony\Component\HttpFoundation\JsonResponse
     */
    public function addJobAction()
    {
        $params = $this->get('request')->request->all();
        $ret = $this->get('RestQueue')
                ->addJob($params);

        if ($ret) {
            $response = new JsonResponse(array('identifier' => $ret));
            $response->setStatusCode('201');
        } else {
            $response = new JsonResponse(array('error' => $this->get('RestQueue')->getLastError()));
            $response->setStatusCode('400');
        }

        return $response;
    }

    /**
     * Pause all items in the queue
     * @return \Symfony\Component\HttpFoundation\JsonResponse
     */
    public function pauseQueueAction()
    {
        $ret = $this->get('RestQueue')
                ->pauseQueue();

        if ($ret) {
            $response = new JsonResponse(array('message' => 'Succes'));
            $response->setStatusCode('200');
        } else {
            $response = new JsonResponse(array('error' => $this->get('RestQueue')->getLastError()));
            $response->setStatusCode('404');
        }

        return $response;
    }

    /**
     * Resume all items in the queue
     * @return \Symfony\Component\HttpFoundation\JsonResponse
     */
    public function continueQueueAction()
    {
        $ret = $this->get('RestQueue')
                ->continueQueue();

        if ($ret) {
            $response = new JsonResponse(array('message' => 'Succes'));
            $response->setStatusCode('200');
        } else {
            $response = new JsonResponse(array('error' => $this->get('RestQueue')->getLastError()));
            $response->setStatusCode('404');
        }

        return $response;
    }

    /**
     * Show the number of queue items in each state
     * @return \Symfony\Component\HttpFoundation\JsonResponse
     */
    public function showQueueStatusAction()
    {
        $ret = $this->get('RestQueue')
                ->showQueueStatus();

        if ($ret) {
            $response = new JsonResponse($ret);
            $response->setStatusCode('200');
        } else {
            $response = new JsonResponse(array('error' => $this->get('RestQueue')->getLastError()));
            $response->setStatusCode('404');
        }

        return $response;
    }

    /**
     * Show the whole queue in json format
     * @return \Symfony\Component\HttpFoundation\JsonResponse
     */
    public function showQueueAction()
    {
        $ret = $this->get('RestQueue')
                ->showQueue();

        if ($ret) {
            $response = new JsonResponse($ret);
            $response->setStatusCode('200');
        } else {
            $response = new JsonResponse(array('error' => $this->get('RestQueue')->getLastError()));
        }
        return $response;
    }

    public function retryCallbackAction()
    {
        $ret = $this->get('RestQueue')
                ->retryCallback();

        if ($ret) {
            $response = new JsonResponse($ret);
            $response->setStatusCode('200');
        } else {
            $response = new JsonResponse(array('error' => $this->get('RestQueue')->getLastError()));
            $response->setStatusCode('404');
        }
        return $response;
    }

}
