<?php

namespace TPC\QueueingBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use TPC\QueueingBundle\Entity\Config;
use Symfony\Component\HttpFoundation\JsonResponse;

class ConfigHandlerController extends Controller {

    /**
     * Show the config database in json format
     * @return Json configvalues
     */
    public function showConfigAction() {
        $ret = $this->get('ConfigHandler')
                ->showConfig();

        if ($ret) {
            $response = new JsonResponse($ret);
        } else {
            $response = new JsonResponse(array('error' => $this->get('ConfigHandler')->getLastError()));
            $response->setStatusCode('404');
        }

        return $response;
    }

    /**
     * Update one or more values in the config database
     * @return succes
     */
    public function updateAction() {
        $params = $this->get('request')->request->all();

        $ret = $this->get('ConfigHandler')
                ->update($params);

        if ($ret) {
            $response = new JsonResponse($ret);
        } else {
            $response = new JsonResponse(array('error' => $this->get('ConfigHandler')->getLastError()));
            $response->setStatusCode('404');
        }
    }

}