<?php

namespace TPC\QueueingBundle\DataFixtures\ORM;

use Doctrine\Common\DataFixtures\FixtureInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Symfony\Component\DependencyInjection\ContainerAwareInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use TPC\QueueingBundle\Entity\QueueStatus;
use TPC\QueueingBundle\Entity\QueueConfig;
use TPC\QueueingBundle\Entity\QueueType;

class LoadFixtures implements FixtureInterface, ContainerAwareInterface
{

    /**
     * @var ContainerInterface
     */
    private $container;
    private $states = array('queued', 'busy', 'paused', 'removed', 'done', 'failed', 'interrupted', 'stopped');
    private $config = array('is_paused' => 0);

    /**
     * {@inheritDoc}
     */
    public function setContainer(ContainerInterface $container = null)
    {
        $this->container = $container;
    }

    /**
     * {@inheritDoc}
     */
    public function load(ObjectManager $manager)
    {

        //Get all parameters to be able to check if a specific key exists
        $params = $this->container->getParameterBag()->all();

        //Check if key exists and isn't empty
        if (array_key_exists('states', $params) && $params['states']) {
            $states = $params['states'];
        } else {
            //else use default array
            $states = $this->states;
        }
        //add each state to database
        foreach ($states as $value) {
            $status = new QueueStatus();
            $status->setName($value);
            $manager->persist($status);
        }

        //Check if key exists and isn't empty
        if (array_key_exists('queue_config', $params) && $params['queue_config']) {
            $config = $params['queue_config'];
        } else {
            //else use default array
            $config = $this->config;
        }
        foreach ($config as $key => $value) {
            //add each config setting to database
            $status = new QueueConfig($key, $value);
            $manager->persist($status);
        }

        $type = new QueueType();
        $type->setName('default');
        $type->setJobLimit(10);
        $manager->persist($type);

        //store on database
        $manager->flush();
    }

}