<?php

namespace TPC\QueueingBundle\Handlers\ApiHandling;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\Container;

class IdRestQueueHandler
{

    private $em;
    private $ct;
    private $lastError;

    public function __construct(EntityManager $em, Container $ct)
    {
        $this->em = $em;
        $this->ct = $ct;
    }

    public function getLastError()
    {
        return $this->lastError;
    }

    public function setLastError($error)
    {
        $this->lastError = $error;
    }

    /**
     * Delete job
     * @param integer  job id
     * @return boolean
     */
    public function delete($id)
    {
        //Get queue item
        $result = $this->em->getRepository($this->ct->getParameter('Queue_repo'))
                ->findOneByIdentifier($id);

        //if item exists, remove it
        if ($result != null) {
            if ($result->getStatus()->getName() == 'busy') {
                //Remove job through connector
                $connector = $this->ct->get('Connector');
                $connector->deleteJob($result);
            }
            $this->em->remove($result);
            $this->em->flush();
        } else {
            $this->setLastError('Id not found');
            return false;
        }
        return true;
    }

    /**
     * pause job
     * @param integer job id
     * @return boolean
     */
    public function pauseJob($id)
    {
        //Get pause status
        $pause = $this->em->getRepository('TPCQueueingBundle:QueueStatus')->findOneByName('Paused');
        //Get Paused status
        $interrupt = $this->em->getRepository('TPCQueueingBundle:QueueStatus')->findOneByName('interrupted');

        //Get queue item
        $result = $this->em->getRepository($this->ct->getParameter('Queue_repo'))
                ->findOneByIdentifier($id);

        //If queue item exists and status is queued or busy; change status to paused
        if ($result != null) {
            //Item in queue can be changed without action
            if ($result->getStatus()->getName() == 'queued') {
                $result->setStatus($pause);
                //Item in progress set to paused. Notice controller to take action  
            } else if ($result->getStatus()->getName() == 'busy') {
                $result->setStatus($interrupt);
                //Stop job trough controller if possible
                $connector = $this->ct->get('Connector');
                $connector->pauseJob($result);
            } else {
                $this->setLastError($result->getIdentifier() . ' can\'t be paused. Status: ' . $result->getStatus()->getName());
                return false;
            }
            $this->em->flush();
        } else {
            $this->setLastError('Id not found');
            return false;
        }
        return true;
    }

    /**
     * Continue job
     * @param integer id
     * @return boolean
     */
    public function continueJob($id)
    {
        //Get queued status
        $queued = $this->em->getRepository('TPCQueueingBundle:QueueStatus')->findOneByName('queued');
        //Get busy status
        $busy = $this->em->getRepository('TPCQueueingBundle:QueueStatus')->findOneByName('busy');


        //Get queue item
        $result = $this->em->getRepository($this->ct->getParameter('Queue_repo'))
                ->findOneByIdentifier($id);

        //If queue item exists and status is pause; change status to queued
        if ($result != null) {
            //paused item back to queued
            if ($result->getStatus()->getName() == 'paused') {
                $result->setStatus($queued);
                //item that was interrupted, back to busy and notify controller    
            } else if ($result->getStatus()->getName() == 'interrupted') {
                $result->setStatus($busy);
                //controller action
                $connector = $this->ct->get('Connector');
                $connector->continueJob($result);
            } else {
                $this->setLastError($result->getIdentifier() . ' can\'t be resumed. Status: ' . $result->getStatus()->getName());
                return false;
            }
            $this->em->flush();
        } else {
            $this->setLastError('Id not found');
            return false;
        }
        return true;
    }

    /**
     * Get job status
     * @param integer id
     * @return string
     */
    public function status($id)
    {
        //Get queue item
        $result = $this->em->getRepository($this->ct->getParameter('Queue_repo'))
                ->findOneByIdentifier($id);
        //If queue item exists
        if ($result != null) {
            return $result->getStatus()->getName();
        } else {
            $this->setLastError('Id not found');
            return false;
        }
    }

    /**
     * Update job parameters
     * @param integer id
     * @return string|boolean
     */
    public function update($id)
    {
        //Get queue item
        $result = $this->em->getRepository($this->ct->getParameter('Queue_repo'))
                ->findOneByIdentifier($id);
        if ($result != null) {
            //Get all parameters
            $params = $this->ct->get('request')->request->all();

            //Loop trough parameters, update in queue when possible
            foreach ($params as $key => $value) {
                if ($key != 'status') {
                    $ret = $result->update($key, $value);
                    if (!$ret) {
                        $this->setLastError($key . ' does not exist');
                        return false;
                    }
                }
            }
            //Status has to be fetched from database before updating.
            if (isset($params['status'])) {
                //Get status entity from database
                $status = $this->em->getRepository('TPCQueueingBundle:QueueStatus')
                        ->findOneByName($params['status']);
                if (is_null($status)) {
                    $this->setLastError('Status not found');
                    return false;
                }
                if ($params['status'] === 'stopped') {
                    $connector = $this->ct->get('Connector');
                    $connector->stopJob($result);
                } else {
                    $result->setStatus($status);
                }
            }
            //finally save all the changes
            $this->em->flush();
        } else {
            $this->setLastError('Id not found');
            return false;
        }
        return true;
    }

    public function forceStart($id)
    {
        $result = $this->em->getRepository($this->ct->getParameter('Queue_repo'))
                ->findOneByIdentifier($id);
        if ($result != null) {
            $connector = $this->ct->get('Connector');
            if ($connector) {
                return $connector->forceStart($result);
            } else {
                $this->setLastError('No connector found');
                return false;
            }
        } else {
            $this->setLastError('Id not found');
            return false;
        }
    }

    public function showJob($id)
    {
        $result = $this->em->getRepository($this->ct->getParameter('Queue_repo'))
                ->findOneByIdentifier($id);
        if ($result != null) {
            return $result->getItems();
        } else {
            $this->setLastError('Id not found');
            return false;
        }
    }

}