<?php

namespace TPC\QueueingBundle\Handlers\ApiHandling;

use Doctrine\ORM\EntityManager;
use Symfony\Component\DependencyInjection\Container;

class ConfigHandler {

    private $em;
    private $ct;
    private $lastError;

    public function __construct(EntityManager $em, Container $ct) {
        $this->em = $em;
        $this->ct = $ct;
    }

    public function getLastError() {
        return $this->lastError;
    }

    public function setLastError($error) {
        $this->lastError = $error;
    }

    /**
     * Return all parameters from config database
     * @return type
     */
    public function showConfig() {

        $configParams = $this->em->getRepository('TPCQueueingBundle:QueueConfig')->findAll();

        if ($configParams) {
            //Convert result to array
            $response = NULL;
            foreach ($configParams as $param) {
                $response[$param->getName()] = $param->getValue();
            }
            return $response;
        } else {
            $this->setLastError('Table QueueConfig not found');
            return false;
        }
    }

    /**
     * Update or add a new config parameter
     * @param array parameters
     * @return boolean
     */
    public function update($params) {
        //Loop trough each key/value pair
        foreach ($params as $key => $value) {
            $configParam = $this->em->getRepository('TPCQueueingBundle:QueueConfig')->findOneByName($key);
            //Find key and update, or create pair
            if ($configParam != NULL) {
                $configParam->setValue($value);
            } else {
                $configParam = new Config($key, $value);
                $configParam->setName($key);
                $configParam->setValue($value);
                $this->em->persist($configParam);
            }
        }
        $this->em->flush();
        return true;
    }

    /**
     * Set the job limit
     * @param integer  job limit
     * @return boolean
     */
    public function setJoblimit($limit) {
        return $this->update(array('job_limit', $limit));
    }

    /**
     * Set the queue pause status
     * @param boolean paused
     * @return boolean
     */
    public function setPaused($setPaused) {
        return $this->update(array('is_paused', $setPaused));
    }

}
