<?php

namespace TPC\QueueingBundle\Walker;

use Doctrine\ORM\Query\SqlWalker;

/**

  SortableNullsWalker
 */
class SortableNullsWalker extends SqlWalker
{

    const NULLS_FIRST = 'NULLS FIRST';
    const NULLS_LAST = 'NULLS LAST';

    public function walkOrderByClause($orderByClause)
    {
        $sql = parent::walkOrderByClause($orderByClause);

        if ($nullFields = $this->getQuery()->getHint('SortableNullsWalker.fields')) {
            if (is_array($nullFields)) {
                $platform = $this->getConnection()->getDatabasePlatform()->getName();


                foreach ($nullFields as $field => $sorting) {

                    $sql = str_replace('DESC', 'DESC NULLS LAST', $sql);

                }
            }
        }
        return $sql;
    }

}