<?php

namespace TPC\QueueingBundle\Handlers\CallbackHandling;

use Guzzle\Http\Client;

/**
 * Description of Callback
 *
 * @author Bart Malestein <bartmalestein88@gmail.com>
 */
class Callback implements Observer {

    public function update($job, $oldValue) {
        $url = $job->getCallbackurl();

        if (!empty($url)) {

            $client = new Client();

            $request = $client->post($url)
                    ->addPostFields(array('identifier' => $job->getIdentifier(),
                'current status' => $job->getStatus()->getName(),
                'previous status' => $oldValue->getName()));

            $response = $request->send();

            if ($response->getBody() == ($job->getIdentifier() . ' received')) {
                //callback succesfull
            } else {
                //callback failed          
                //new failedCallback(url, array(id,cstatus,ostatus), lastupdate, retrycount)
            }
        }
    }

}