<?php

declare(strict_types=1);

namespace IssetBV\PushNotificationConnectionsEntityBundle\Service;

use Doctrine\Common\Persistence\ObjectManager;
use IssetBV\PushNotificationBundle\Service\Core\Connection\Connection;
use IssetBV\PushNotificationBundle\Service\Core\Connection\ConnectionHandlerExceptionImpl;
use IssetBV\PushNotificationBundle\Service\Core\Connection\ConnectionHandlerImpl;
use IssetBV\PushNotificationConnectionsEntityBundle\Entity\PushNotificationConnection;
use IssetBV\PushNotificationConnectionsEntityBundle\Repository\PushNotificationConnectionRepository;
use IssetBV\PushNotificationConnectionsEntityBundle\Service\Converter\ConnectionConverterContainer;

/**
 * Class EntityConnectionHandler.
 */
class EntityConnectionHandler extends ConnectionHandlerImpl
{
    /**
     * @var PushNotificationConnectionRepository
     */
    private $pushNotificationConnectionRepository;
    /**
     * @var ConnectionConverterContainer
     */
    private $converterContainer;

    /**
     * EntityConnectionHandler constructor.
     *
     * @param ObjectManager $objectManager
     * @param ConnectionConverterContainer $converterContainer
     */
    public function __construct(ObjectManager $objectManager, ConnectionConverterContainer $converterContainer)
    {
        $this->pushNotificationConnectionRepository = $objectManager->getRepository(PushNotificationConnection::class);
        $this->converterContainer = $converterContainer;
    }

    /**
     * @param string $type
     *
     * @throws ConnectionHandlerExceptionImpl
     *
     * @return Connection
     */
    public function getConnection(string $type = null): Connection
    {
        if (!parent::hasConnectionType($type)) {
            $connectionData = $this->pushNotificationConnectionRepository->fetchByType($type);
            if ($connectionData === null) {
                throw new ConnectionHandlerExceptionImpl('connection not found for type: ' . $type);
            }
            $this->addConnection($this->converterContainer->convert($connectionData));
        }

        return parent::getConnection($type);
    }
}
