<?php

declare(strict_types=1);

namespace IssetBV\PushNotificationConnectionsEntityBundle\Service\Converter;

use IssetBV\PushNotificationBundle\Service\Apple\AppleConnection;
use IssetBV\PushNotificationBundle\Service\Core\Connection\Connection;
use IssetBV\PushNotificationConnectionsEntityBundle\Entity\PushNotificationConnection;
use IssetBV\PushNotificationConnectionsEntityBundle\Entity\PushNotificationConnectionApple;

/**
 * Class AppleConnectionConverter.
 */
class AppleConnectionConverter implements ConnectionConverter
{
    /**
     * @param PushNotificationConnection|PushNotificationConnectionApple $connection
     *
     * @return Connection
     */
    public function convert(PushNotificationConnection $connection): Connection
    {
        $url = $connection->getUrl();
        $type = $connection->getType();
        $pemKeyFile = $connection->getPemKeyFile();
        $pemPasswordPhrase = $connection->getPemPasswordPhrase();
        $default = $connection->getDefault();

        return new AppleConnection($url, $type, $pemKeyFile, $pemPasswordPhrase, $default);
    }

    /**
     * @param PushNotificationConnection $connection
     *
     * @return bool
     */
    public function handles(PushNotificationConnection $connection): bool
    {
        return $connection instanceof PushNotificationConnectionApple;
    }
}
