<?php

declare(strict_types=1);

namespace IssetBV\PushNotificationConnectionsEntityBundle\Service\Converter;

use IssetBV\PushNotificationBundle\Service\Android\AndroidConnection;
use IssetBV\PushNotificationBundle\Service\Core\Connection\Connection;
use IssetBV\PushNotificationConnectionsEntityBundle\Entity\PushNotificationConnection;
use IssetBV\PushNotificationConnectionsEntityBundle\Entity\PushNotificationConnectionAndroid;

/**
 * Class AndroidConnectionConverter.
 */
class AndroidConnectionConverter implements ConnectionConverter
{
    /**
     * @param PushNotificationConnection|PushNotificationConnectionAndroid $connection
     *
     * @return Connection
     */
    public function convert(PushNotificationConnection $connection): Connection
    {
        $type = $connection->getType();
        $apiUrl = $connection->getApiUrl();
        $apiKey = $connection->getApiKey();
        $timeout = $connection->getTimeout();
        $dryRun = $connection->isDryRun();
        $default = $connection->getDefault();

        return new AndroidConnection($type, $apiUrl, $apiKey, $timeout, $dryRun, $default);
    }

    /**
     * @param PushNotificationConnection $connection
     *
     * @return bool
     */
    public function handles(PushNotificationConnection $connection): bool
    {
        return $connection instanceof PushNotificationConnectionAndroid;
    }
}
