<?php

declare(strict_types=1);

namespace IssetBV\PushNotificationConnectionsEntityBundle\Repository;

use Doctrine\ORM\EntityRepository;
use IssetBV\PushNotificationConnectionsEntityBundle\Entity\PushNotificationConnection;

/**
 * Class PushNotificationConnectionRepository.
 */
class PushNotificationConnectionRepository extends EntityRepository
{
    /**
     * @param string $type
     *
     * @return PushNotificationConnection|null
     */
    public function fetchByType(string $type)
    {
        $qb = $this->createQueryBuilder('pnc');
        $qb->where('pnc.type = :type');
        $qb->setParameter('type', $type);

        return $qb->getQuery()->getOneOrNullResult();
    }
}
