<?php

declare(strict_types=1);

namespace IssetBV\PushNotificationBundle\Service\Windows\Message;

use IssetBV\PushNotificationBundle\Service\Core\Message\Message;

/**
 * Class WindowsMessage.
 */
class WindowsMessage implements Message
{
    /**
     * @var string
     */
    private $identifier;

    /**
     * @var array
     */
    private $payload = [];

    /**
     * WindowsMessage constructor.
     *
     * @param string $identifier
     */
    public function __construct(string $identifier)
    {
        $this->identifier = $identifier;
    }

    /**
     * @return mixed
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }

    /**
     * @param string $key
     *
     * @return bool
     */
    public function payloadContainsKey(string $key): bool
    {
        return array_key_exists($key, $this->payload);
    }

    /**
     * @param string $key
     * @param $value
     */
    public function addToPayload(string $key, $value)
    {
        $this->payload[$key] = $value;
    }

    /**
     * @return mixed
     */
    public function getMessage()
    {
        return $this->payload;
    }
}
