<?php

declare(strict_types=1);

namespace IssetBV\PushNotificationBundle\Service\Core\Message;

use IssetBV\PushNotificationBundle\Service\Core\Response;
use PhpOption\Option;

/**
 * Interface MessageEnvelope.
 */
interface MessageEnvelope
{
    const SUCCESS = 'success';
    const PENDING = 'pending';
    const FAILED = 'failed';
    const PARTIAL_FAILED = 'partial_failed';

    /**
     * @return Message
     */
    public function getMessage(): Message;

    /**
     * @return string
     */
    public function getState(): string;

    /**
     * @param string $state
     */
    public function setState(string $state);

    /**
     * @return Option<Response>
     */
    public function getResponse(): Option;

    /**
     * @param Response $response
     *
     * @return Response
     */
    public function setResponse(Response $response);
}
