<?php

declare(strict_types=1);

namespace IssetBV\PushNotificationBundle\Service\Core;

use IssetBV\PushNotificationBundle\Service\Core\Message\Message;
use IssetBV\PushNotificationBundle\Service\Core\Message\MessageEnvelope;
use Psr\Log\LoggerAwareInterface;

/**
 * Interface Notifier.
 */
interface Notifier extends LoggerAwareInterface
{
    /**
     * @param Message $message
     * @param string $connectionName
     *
     * @return MessageEnvelope
     */
    public function send(Message $message, string $connectionName = null): MessageEnvelope;

    /**
     * @param Message $message
     * @param string|null $connectionName
     *
     * @return MessageEnvelope
     */
    public function queue(Message $message, string $connectionName = null): MessageEnvelope;

    /**
     * @param Message $message
     *
     * @return bool
     */
    public function handles(Message $message): bool;

    /**
     * Flushes the queue to the notifier queues.
     */
    public function flushQueue();
}
