<?php

declare(strict_types=1);

namespace IssetBV\PushNotificationBundle\Service\Core\Message;

use IssetBV\PushNotificationBundle\Service\Core\Response;

abstract class MessageEnvelopeAbstract implements MessageEnvelope
{
    /**
     * @var Response
     */
    private $response;

    /**
     * @var string
     */
    private $request;

    /**
     * @var string
     */
    private $state = self::PENDING;

    /**
     * @param string $state
     */
    public function setState(string $state)
    {
        $this->state = $state;
    }

    /**
     * @return string
     */
    public function getState(): string
    {
        return $this->state;
    }

    /**
     * @return Response|null
     */
    public function getResponse()
    {
        return $this->response;
    }

    /**
     * @param Response $response
     *
     * @return Response
     */
    public function setResponse(Response $response)
    {
        $this->response = $response;
    }

    /**
     * @return string
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param string $request
     *
     * @return string
     */
    public function setRequest(string $request)
    {
        return $this->request = $request;
    }
}
