<?php

declare(strict_types=1);

namespace IssetBV\PushNotificationBundle\Service\Core\Connection;

use IssetBV\PushNotificationBundle\Service\Core\Response;

class ConnectionResponseImpl implements Response
{
    /**
     * @var bool
     */
    private $success = true;
    /**
     * @var mixed
     */
    private $response = null;

    /**
     * @return bool
     */
    public function isSuccess(): bool
    {
        return $this->success;
    }

    /**
     * @param bool $success
     */
    public function setSuccess(bool $success)
    {
        $this->success = $success;
    }

    /**
     * @return mixed
     */
    public function getResponse()
    {
        return $this->response;
    }

    /**
     * @param mixed $errorResponse
     */
    public function setErrorResponse($errorResponse)
    {
        $this->setSuccess(false);
        $this->response = $errorResponse;
    }

    /**
     * @param $response
     */
    public function setResponse($response)
    {
        $this->response = $response;
    }
}
