<?php

declare(strict_types=1);

namespace IssetBV\PushNotificationBundle\Service\Android\Message;

use IssetBV\PushNotificationBundle\Service\Core\Message\Message;
use IssetBV\PushNotificationBundle\Service\Core\Message\MessageEnvelopeAbstract;

class AndroidMessageEnvelope extends MessageEnvelopeAbstract
{
    /**
     * @var AndroidMessage
     */
    private $androidMessage;

    /**
     * AndroidMessageEnvelope constructor.
     *
     * @param AndroidMessage $androidMessage
     */
    public function __construct(AndroidMessage $androidMessage)
    {
        $this->androidMessage = $androidMessage;
    }

    /**
     * @return Message
     */
    public function getMessage(): Message
    {
        return $this->androidMessage;
    }
}
