<?php

declare(strict_types=1);

namespace IssetBV\PushNotificationBundle\Service\Apple\Message;

use IssetBV\PushNotificationBundle\Service\Core\Message\Message;
use IssetBV\PushNotificationBundle\Service\Core\Message\MessageEnvelopeAbstract;

/**
 * Class AppleMessageEnvelope.
 */
class AppleMessageEnvelope extends MessageEnvelopeAbstract
{
    /**
     * @var AppleMessage
     */
    private $appleMessage;

    /**
     * AppleMessageEnvelope constructor.
     *
     * @param AppleMessage $appleMessage
     */
    public function __construct(AppleMessage $appleMessage)
    {
        $this->appleMessage = $appleMessage;
    }

    /**
     * @return Message
     */
    public function getMessage(): Message
    {
        return $this->appleMessage;
    }
}
