<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Android\Message;

use IssetBV\PushNotificationBundle\Service\Core\Message\Message;

class AndroidMessage implements Message
{

    /**
     * @var array
     */
    private $messageBody;

    /**
     * AndroidMessage constructor.
     * @param string $identifier
     */
    public function __construct(string $identifier)
    {
        $this->messageBody = [
            'to' => $identifier,
            'data.message' => null
        ];

    }

    /**
     * @return string
     */
    public function getIdentifier()
    {
        return $this->messageBody['to'];
    }

    /**
     * @param $message
     */
    public function setMessage($message)
    {
        $this->messageBody['data.message'] = $message;
    }

    /**
     * @return mixed
     */
    public function getMessage()
    {
        return $this->messageBody['data.message'];
    }

    /**
     * @param string $key
     * @return bool
     */
    public function hasOption(string $key): bool
    {
        return array_key_exists($key, $this->messageBody);
    }

    /**
     * @param string $key
     * @param $value
     */
    public function addOption(string $key, $value)
    {
        $this->messageBody[$key] = $value;
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return $this->messageBody;
    }

}