<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core\Message;

use IssetBV\PushNotificationBundle\Service\Core\Response;

/**
 * Interface MessageEnvelope
 * @package IssetBV\PushNotificationBundle\Service\Core
 */
interface MessageEnvelope
{

    CONST SUCCESS = 'success';
    CONST PENDING = 'pending';
    CONST FAILED = 'failed';
    CONST PARTIAL_FAILED = 'partial_failed';

    /**
     * @return Message
     */
    public function getMessage(): Message;

    /**
     * @return string
     */
    public function getState(): string;

    /**
     * @param string $state
     */
    public function setState(string $state);

    /**
     * @return Response|null
     */
    public function getResponse();

    /**
     * @param Response $response
     * @return Response
     */
    public function setResponse(Response $response);

    /**
     * @return string
     */
    public function getRequest();

    /**
     * @param string $request
     * @return mixed
     */
    public function setRequest(string $request);

}