<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core\Message;

/**
 * Interface MessageEnvelopeQueue
 * @package IssetBV\PushNotificationBundle\Service\Core
 */
interface MessageEnvelopeQueue
{

    /**
     * @return MessageEnvelope[]
     */
    public function getQueue(): array;

    /**
     * @param MessageEnvelope $message
     */
    public function add(MessageEnvelope $message);

    /**
     * @param string $identifier
     * @return MessageEnvelope
     */
    public function removeToIdentifier($identifier): MessageEnvelope;

    /**
     * @return bool
     */
    public function isEmpty(): bool;

    public function reset();

    /**
     * @param $state
     * @return mixed
     */
    public function setState($state);
}