<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core\Connection;

use IssetBV\PushNotificationBundle\Service\Core\Message\MessageEnvelope;
use IssetBV\PushNotificationBundle\Service\Core\Response;
use Psr\Log\LoggerAwareInterface;

/**
 * Interface Connection
 * @package IssetBV\PushNotificationBundle\Service\Core\Connection
 */
interface Connection extends LoggerAwareInterface
{

    /**
     * @param MessageEnvelope $messageEnvelope
     * @throws ConnectionException
     * @throws ConnectionHandlerException
     */
    public function send(MessageEnvelope $messageEnvelope);

    /**
     * Send a message without waiting on response
     *
     * @param MessageEnvelope $messageEnvelope
     * @throws ConnectionException
     */
    public function sendMessage(MessageEnvelope $messageEnvelope);

    /**
     * @return string
     */
    public function getType(): string;

    /**
     * @return bool
     */
    public function isDefault(): bool;
}