<?php

namespace IssetBV\PushNotificationBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{

    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('isset_bv_push_notification');
        $this->addApple($rootNode);
        $this->addAndroid($rootNode);
        return $treeBuilder;
    }

    private function addApple(ArrayNodeDefinition $rootNode)
    {
        $rootNode->children()
            ->arrayNode('apple')
            ->prototype('array')
            ->children()
            ->scalarNode('url')->cannotBeEmpty()->isRequired()->end()
            ->scalarNode('pem')->cannotBeEmpty()->isRequired()->end()
            ->scalarNode('passphrase')->defaultValue('')->end()
            ->scalarNode('default')->defaultFalse()->end()
            ->end()
            ->end()
            ->end()
            ->end();

    }

    private function addAndroid(ArrayNodeDefinition $rootNode)
    {
        $rootNode->children()
            ->arrayNode('android')
            ->prototype('array')
            ->children()
            ->scalarNode('url')->defaultValue('https://android.googleapis.com/gcm/send')->end()
            ->scalarNode('api_key')->cannotBeEmpty()->isRequired()->end()
            ->scalarNode('timeout')->defaultValue(5)->end()
            ->scalarNode('default')->defaultFalse()->end()
            ->scalarNode('dry_run')->defaultFalse()->end()
            ->end()
            ->end()
            ->end()
            ->end();

    }

}
