<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core\Message;

use LogicException;

/**
 * Class MessageEnvelopeQueueImpl
 * @package IssetBV\PushNotificationBundle\Service\Core\Message
 */
class MessageEnvelopeQueueImpl implements MessageEnvelopeQueue
{

    /**
     * @var MessageEnvelope[]
     */
    private $queue = [];

    /**
     * @return MessageEnvelope[]
     */
    public function getQueue(): array
    {
        return $this->queue;
    }

    /**
     * @param MessageEnvelope $message
     */
    public function add(MessageEnvelope $message)
    {
        $this->queue[] = $message;
    }

    /**
     * @param string $identifier
     * @return MessageEnvelope
     * @throws LogicException
     */
    public function removeToIdentifier($identifier): MessageEnvelope
    {
        $return = null;
        $newQueue = [];
        $found = false;
        foreach ($this->queue as $id => $item) {
            if ($item->getMessage()->getIdentifier() === $identifier) {
                $item->setState(MessageEnvelope::FAILED);
                $return = $item;
                $found = true;
            } elseif (!$found) {
                $item->setState(MessageEnvelope::SUCCESS);
            } else {
                $newQueue[] = $item;
            }
        }
        $this->queue = $newQueue;

        if ($return === null) {
            throw new LogicException('identifier not found');
        }

        return $return;
    }

    /**
     * @return bool
     */
    public function isEmpty(): bool
    {
        return count($this->queue) === 0;
    }

    public function reset()
    {
        $this->queue = [];
    }

    public function setState($state)
    {
        foreach ($this->queue as $item) {
            $item->setState($state);
        }
    }
}