<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core\Message;

use IssetBV\PushNotificationBundle\Service\Core\Response;

abstract class MessageEnvelopeAbstract implements MessageEnvelope
{

    /**
     * @var Response
     */
    private $response;

    /**
     * @var string
     */
    private $request;

    public function __construct()
    {
        $this->setState(MessageEnvelope::PENDING);
    }

    /**
     * @return Response|null
     */
    public function getResponse()
    {
        return $this->response;
    }

    /**
     * @param Response $response
     * @return Response
     */
    public function setResponse(Response $response)
    {
        $this->response = $response;
    }

    /**
     * @return string
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * @param string $request
     * @return string
     */
    public function setRequest(string $request)
    {
        return $this->request = $request;
    }
}