<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core;

use IssetBV\PushNotificationBundle\Service\Core\Message\Message;
use IssetBV\PushNotificationBundle\Service\Core\Message\MessageEnvelope;
use Psr\Log\LoggerAwareInterface;

/**
 * Interface Notifier
 * @package IssetBV\PushNotificationBundle\Service\Core
 */
interface Notifier extends LoggerAwareInterface
{

    /**
     * @param Message $message
     * @param string $connectionName
     * @return Response
     */
    public function send(Message $message, string $connectionName = null): Response;

    /**
     * @param Message $message
     * @param string|null $connectionName
     * @return MessageEnvelope
     */
    public function queue(Message $message, string $connectionName = null): MessageEnvelope;

    /**
     * @param Message $message
     * @return bool
     */
    public function handles(Message $message): bool;

    /**
     * Flushes the queue to the notifier queues
     */
    public function flushQueue();

}