<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Android\Message;

use IssetBV\PushNotificationBundle\Service\Core\Message\Message;
use IssetBV\PushNotificationBundle\Service\Core\Message\MessageEnvelope;

class AndroidMessageEnvelope implements MessageEnvelope
{

    /**
     * @var AndroidMessage
     */
    private $androidMessage;
    /**
     * @var string
     */
    private $state;

    /**
     * AndroidMessageEnvelope constructor.
     * @param AndroidMessage $androidMessage
     */
    public function __construct(AndroidMessage $androidMessage)
    {
        $this->androidMessage = $androidMessage;
    }

    /**
     * @return Message
     */
    public function getMessage(): Message
    {
        return $this->androidMessage;
    }

    /**
     * @param string $state
     */
    public function setState(string $state)
    {
        $this->state = $state;
    }
}