<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core\Message;

/**
 * Class MessageEnvelopeQueueImpl
 * @package IssetBV\PushNotificationBundle\Service\Core\Message
 */
class MessageEnvelopeQueueImpl implements MessageEnvelopeQueue
{

    /**
     * @var MessageEnvelope[]
     */
    private $queue = [];

    /**
     * @return MessageEnvelope[]
     */
    public function getQueue(): array
    {
        return $this->queue;
    }

    /**
     * @param MessageEnvelope $message
     */
    public function add(MessageEnvelope $message)
    {
        $this->queue[] = $message;
    }

    /**
     * @param string $identifier
     */
    public function removeToIdentifier($identifier)
    {
        $newQueue = [];
        $found = false;
        foreach ($this->queue as $id => $item) {
            if ($item->getMessage()->getIdentifier() === $identifier) {
                $item->setState(MessageEnvelope::FAILED);
                $found = true;
            } elseif (!$found) {
                $item->setState(MessageEnvelope::SUCCESS);
            } else {
                $newQueue[] = $item;
            }
        }
        $this->queue = $newQueue;
    }

    /**
     * @return bool
     */
    public function isEmpty(): bool
    {
        return count($this->queue) === 0;
    }

    public function reset()
    {
        $this->queue = [];
    }

    public function setState($state)
    {
        foreach ($this->queue as $item) {
            $item->setState($state);
        }
    }
}