<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core\Connection;

use IssetBV\PushNotificationBundle\Service\Core\Message\Message;
use IssetBV\PushNotificationBundle\Service\Core\Response;
use Psr\Log\LoggerAwareInterface;

/**
 * Interface Connection
 * @package IssetBV\PushNotificationBundle\Service\Core\Connection
 */
interface Connection extends LoggerAwareInterface
{

    /**
     * @param Message $message
     * @return Response
     * @throws ConnectionException
     * @throws ConnectionHandlerException
     */
    public function send(Message $message): Response;

    /**
     * Send a message without waiting on response
     *
     * @param Message $message
     * @throws ConnectionException
     * @throws ConnectionHandlerException
     */
    public function sendMessage(Message $message);

    /**
     * @return string
     */
    public function getType(): string;

    /**
     * @return bool
     */
    public function isDefault(): bool;
}