<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Apple\Message;

use IssetBV\PushNotificationBundle\Service\Core\Message\Message;
use IssetBV\PushNotificationBundle\Service\Core\Message\MessageEnvelope;

/**
 * Class AppleMessageEnvelope
 * @package IssetBV\PushNotificationBundle\Service\Apple\Message
 */
class AppleMessageEnvelope implements MessageEnvelope
{

    /**
     * @var AppleMessage
     */
    private $appleMessage;
    /**
     * @var string
     */
    private $state = self::PENDING;

    /**
     * AppleMessageEnvelope constructor.
     * @param AppleMessage $appleMessage
     */
    public function __construct(AppleMessage $appleMessage)
    {
        $this->appleMessage = $appleMessage;
    }

    /**
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * @return Message
     */
    public function getMessage(): Message
    {
        return $this->appleMessage;
    }

    /**
     * @param string $state
     */
    public function setState(string $state)
    {
        $this->state = $state;
    }
}