<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core;

use IssetBV\PushNotificationBundle\Service\LoggerTrait;
use LogicException;

/**
 * Class NotifierAbstract
 * @package IssetBV\PushNotificationBundle\Service\Core
 */
abstract class NotifierAbstract implements Notifier
{

    use LoggerTrait;

    /**
     * @param Message $message
     * @param string $connectionName
     * @return Response
     * @throws LogicException
     */
    public function send(Message $message, string $connectionName = null): Response
    {
        if (!$this->handles($message)) {
            throw new LogicException('Message couldn\'t be handled by this notifier');
        }
        return $this->sendMessage($message);
    }

    /**
     * @param Message $message
     * @param string $connectionName
     * @return MessageEnvelope
     * @throws LogicException
     */
    public function queue(Message $message, string $connectionName = null): MessageEnvelope
    {
        if (!$this->handles($message)) {
            throw new LogicException('Message couldn\'t be handled by this notifier');
        }
        return $this->addToQueue($message, $connectionName);
    }

    /**
     * @param Message $message
     * @param string $connectionName
     * @return Response
     */
    abstract protected function sendMessage(Message $message, string $connectionName = null): Response;

    /**
     * @param Message $message
     * @param string|null $connectionName
     * @return MessageEnvelope
     */
    abstract protected function addToQueue(Message $message, string $connectionName = null): MessageEnvelope;

}