<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core;

/**
 * Interface MessageEnvelopeQueue
 * @package IssetBV\PushNotificationBundle\Service\Core
 */
interface MessageEnvelopeQueue
{

    /**
     * @return MessageEnvelope[]
     */
    public function getQueue(): array;

    /**
     * @param MessageEnvelope $message
     */
    public function add(MessageEnvelope $message);

    /**
     * @param string $identifier
     */
    public function removeToIdentifier($identifier);

    /**
     * @return bool
     */
    public function isEmpty(): bool;

    public function reset();

    public function setState($state);
}