<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core;

/**
 * Interface MessageEnvelope
 * @package IssetBV\PushNotificationBundle\Service\Core
 */
interface MessageEnvelope
{

    CONST SUCCESS = 'success';
    CONST PENDING = 'pending';
    CONST FAILED = 'failed';

    /**
     * @return Message
     */
    public function getMessage(): Message;

    /**
     * @param string $state
     */
    public function setState(string $state);
}