<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Android;

use GuzzleHttp\Client;
use IssetBV\PushNotificationBundle\Service\Core\Message;
use IssetBV\PushNotificationBundle\Service\Core\MessageEnvelope;
use IssetBV\PushNotificationBundle\Service\Core\MessageEnvelopeQueue;
use IssetBV\PushNotificationBundle\Service\Core\MessageEnvelopeQueueImpl;
use IssetBV\PushNotificationBundle\Service\Core\NotifierAbstract;
use IssetBV\PushNotificationBundle\Service\Core\Response;

/**
 * Class AndroidNotifier
 * @package IssetBV\PushNotificationBundle\Service\Android
 */
class AndroidNotifier extends NotifierAbstract
{

    /**
     * @var MessageEnvelopeQueue
     */
    private $queue;
    /**
     * @var Client
     */
    private $client;
    /**
     * @var bool
     */
    private $dryRun;

    /**
     * AndroidNotifier constructor.
     * @param string $apiUrl
     * @param string $apiKey
     * @param int $timeout
     * @param bool $dryRun
     */
    public function __construct(string $apiUrl, string $apiKey, int $timeout, bool $dryRun = false)
    {
        $this->queue = new MessageEnvelopeQueueImpl();

        $this->client = new Client([
            'base_uri' => rtrim($apiUrl, '/'),
            'headers' => [
                'Content-Type' => 'application/json',
                'Authorization: key' => $apiKey,
            ]
        ]);
        $this->dryRun = $dryRun;
    }

    /**
     * @param Message $message
     * @return bool
     */
    public function handles(Message $message): bool
    {
        return $message instanceof AndroidMessage;
    }

    /**
     * Flushes the queue to the notifier queues
     */
    public function flushQueue()
    {

        // TODO: Implement flushQueue() method.
    }

    /**
     * @param Message $message
     * @param string $connectionName
     * @return Response
     */
    protected function sendMessage(Message $message, string $connectionName = null): Response
    {
        /* @var AndroidMessage $message */

        $this->client

    }

    /**
     * @param Message $message
     * @param string|null $connectionName
     * @return MessageEnvelope
     */
    protected function addToQueue(Message $message, string $connectionName = null): MessageEnvelope
    {
        /* @var AndroidMessage $message */

        $envelope = new AndroidMessageEnvelope($message);
        $this->queue->add($envelope);
        return $envelope;
    }

}