<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Android;

use IssetBV\PushNotificationBundle\Service\Core\Message;

class AndroidMessage implements Message
{

    /**
     * @var array
     */
    private $messageBody;

    /**
     * AndroidMessage constructor.
     * @param string $identifier
     */
    public function __construct(string $identifier)
    {
        $this->messageBody = [
            'registration_ids' => [$identifier],
            'data' => [
                'message' => ''
            ]
        ];

    }

    /**
     * @return string
     */
    public function getIdentifier()
    {
        return $this->messageBody['registration_id'][0];
    }

    /**
     * @param string $message
     */
    public function setMessage(string $message)
    {
        $this->messageBody['data']['message'] = $message;
    }

    /**
     * @return string
     */
    public function getMessage(): string
    {
        return $this->messageBody['data']['message'];
    }

    /**
     * @param string $key
     * @param $value
     */
    public function addData(string $key, $value)
    {
        $this->messageBody['data'][$key] = $value;
    }

    /**
     * @param string $key
     * @return bool
     */
    public function hasOption(string $key): bool
    {
        return array_key_exists($key, $this->messageBody);
    }

    /**
     * @param string $key
     * @param $value
     */
    public function addOption(string $key, $value)
    {
        $this->messageBody[$key] = $value;
    }

    /**
     * @return array
     */
    public function toArray(): array
    {
        return $this->messageBody;
    }

}