<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core;

use IssetBV\PushNotificationBundle\Service\LoggerTrait;
use LogicException;

abstract class NotifierAbstract implements Notifier
{

    use LoggerTrait;

    /**
     * @param Message $message
     * @return Response
     * @throws LogicException
     * @throws NotifyFailedException
     */
    public function send(Message $message): Response
    {
        if (!$this->handles($message)) {
            throw new LogicException('Message couldn\'t be handled by this notifier');
        }
        return $this->sendMessage($message);
    }

    /**
     * @param Message $message
     * @return Response
     * @throws NotifyFailedException
     */
    abstract protected function sendMessage(Message $message): Response;

}