<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Core;

use Psr\Log\LoggerAwareInterface;

/**
 * Interface Notifier
 * @package IssetBV\PushNotificationBundle\Service\Core
 */
interface Notifier extends LoggerAwareInterface
{

    /**
     * @param Message $message
     * @return Response
     * @throws NotifyFailedException
     */
    public function send(Message $message): Response;

    /**
     * @param Message $message
     * @return bool
     */
    public function handles(Message $message): bool;


}