<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Apple\Message;

use IssetBV\PushNotificationBundle\Service\Apple\Connection\ConnectionHandler;
use IssetBV\PushNotificationBundle\Service\Apple\Connection\ConnectionHandlerException;

/**
 * Class AppleMessageFactory
 * @package IssetBV\PushNotificationBundle\Service\Apple\Message
 */
class AppleMessageFactory
{

    /**
     * @var ConnectionHandler
     */
    private $connectionHandler;
    /**
     * @var int
     */
    private $messageCounter = 0;

    /**
     * AppleMessageFactory constructor.
     * @param ConnectionHandler $connectionHandler
     */
    public function __construct(ConnectionHandler $connectionHandler)
    {
        $this->connectionHandler = $connectionHandler;
    }

    /**
     * @param string $type
     * @return AppleAPNSMessage
     * @throws ConnectionHandlerException
     */
    public function createAPNSMessage(string $type): AppleAPNSMessage
    {
        if (!$this->connectionHandler->hasConnectionType($type)) {
            throw new ConnectionHandlerException('connection not found for type: ' . $type);
        }
        return new AppleAPNSMessage($type, $this->messageCounter++);
    }

    /**
     * @return AppleAPNSMessage
     * @throws ConnectionHandlerException
     */
    public function createAPNSMessageWithDefaultConnection(): AppleAPNSMessage
    {
        return $this->createAPNSMessage($this->connectionHandler->getDefaultConnection()->getType());
    }

}