<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Apple\Message;

/**
 * Class AppleAPNMessage
 * @package IssetBV\PushNotificationBundle\Service\Apple\Message
 */
class AppleAPNSMessage extends AppleMessage
{

    /**
     * @var AppleMessageAps
     */
    private $appleMessageAps;

    private $payload = [];

    /**
     * @return AppleMessageAps
     */
    public function getAps()
    {
        if ($this->appleMessageAps === null) {
            $this->appleMessageAps = new AppleMessageAps();
        }
        return $this->appleMessageAps;
    }

    /**
     * @param AppleMessageAps $appleMessageAps
     */
    public function setAppleMessageAps(AppleMessageAps $appleMessageAps)
    {
        $this->appleMessageAps = $appleMessageAps;
    }

    public function addToPayload(string $item, $value)
    {
        $this->payload[$item] = $value;
    }

    /**
     * @return array
     */
    public function getMessage(): array
    {
        $message = $this->payload;
        if ($this->getAppleMessageAps() !== null) {
            $message['aps'] = $this->getAppleMessageAps()->toArray();
        }
        return $message;
    }
}