<?php
declare(strict_types = 1);

namespace IssetBV\PushNotificationBundle\Service\Apple\Connection;

use IssetBV\PushNotificationBundle\Service\Core\Response;

class ConnectionResponse implements Response
{

    /**
     * @var bool
     */
    private $success = true;
    /**
     * @var mixed
     */
    private $errorResponse = null;

    /**
     * @return bool
     */
    public function isSuccess(): bool
    {
        return $this->success;
    }

    /**
     * @param bool $success
     */
    public function setSuccess(bool $success)
    {
        $this->success = $success;
    }

    /**
     * @return mixed
     */
    public function getErrorResponse()
    {
        return $this->errorResponse;
    }

    /**
     * @param mixed $errorResponse
     */
    public function setErrorResponse($errorResponse)
    {
        $this->setSuccess(false);
        $this->errorResponse = $errorResponse;
    }

}