<?php

namespace IssetBV\PushNotificationBundle\DependencyInjection;

use IssetBV\PushNotificationBundle\Service\Apple\Connection\Connection;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @link http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class IssetBVPushNotificationExtension extends Extension
{

    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        if (array_key_exists('apple', $config)) {
            $this->buildApple($loader, $container, $config['apple']);
        }

    }

    private function buildApple(YamlFileLoader $loader, ContainerBuilder $container, array $connections)
    {

        $loader->load('apple.yml');
        foreach ($connections as $type => $connection) {
            $definition = $container->register('isset_bv_push_notification.apple.connection.' . $type, Connection::class);
            $definition->addArgument($connection['url']);
            $definition->addArgument($type);
            $definition->addArgument($connection['pem']);
            $definition->addArgument($connection['passphrase'] ?? null);
            $definition->addArgument($connection['default']);
            $definition->addTag('isset_bv_push_notification.apple.connection');
        }

    }

}
