<?php

declare (strict_types = 1);

namespace IssetBV\Core\PresenterBundle;

use IssetBV\Core\PresenterBundle\Test\TestPresenter;
use PHPUnit\Framework\TestCase;
use stdClass;

/**
 * Class PresenterAdapterTest.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class PresenterAdapterTest extends TestCase
{
    /**
     * @test
     */
    public function it_should_return_array_object()
    {
        $testPresenter = new TestPresenter();

        $presented = $testPresenter->present('nothing');

        TestCase::assertArrayHasKey('a', $presented);
        TestCase::assertArrayHasKey('b', $presented);
    }

    /**
     * @test
     */
    public function it_should_return_collection_of_array_objects()
    {
        $testPresenter = new TestPresenter();

        $presented = $testPresenter->present([1, 2, 3, 4, 5]);

        TestCase::assertCount(5, $presented);
    }

    /**
     * @test
     */
    public function it_should_execute_map_child_presenters()
    {
        $mock = $this->getMockBuilder(stdClass::class)
            ->setMethods(['getElements'])
            ->getMock();

        $mock->expects(TestCase::once())
            ->method('getElements')
            ->willReturn([
                'element' => 'This is an element'
            ]);


        $testPresenter = new TestPresenter();
        $testPresenter->mapChildPresenter('elements', new TestPresenter());

        /** @var array $data */
        $data = $testPresenter->present($mock);

        TestCase::assertArrayHasKey('elements', $data);
        TestCase::assertArrayHasKey('a', $data);
        TestCase::assertArrayHasKey('b', $data);

        TestCase::assertInternalType('array', $data['elements']);
    }

    /**
     * @test
     */
    public function it_should_praise_allah()
    {
        $testPresenter = new TestPresenter();
        $testPresenter->registerClosure(
            function ($presentable) {
                return [
                    'test' => 'test2'
                ];
            }
        );

        /** @var array $data */
        $data = $testPresenter->present('test');

        TestCase::assertArrayHasKey('a', $data);
        TestCase::assertArrayHasKey('b', $data);
        TestCase::assertArrayHasKey('test', $data);
        TestCase::assertEquals('test2', $data['test']);
    }
}
