<?php
declare(strict_types = 1);

namespace IssetBV\Core\PresenterBundle\Test;

use IssetBV\Core\PresenterBundle\Presenter\PresenterAdapter;

/**
 * Class TestPresenter.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
class TestPresenter extends PresenterAdapter
{

    /**
     * @param mixed $presentable
     *
     * @return bool
     */
    public function supports($presentable) : bool
    {
        return true;
    }

    /**
     * Type hint the param annotation in subclass to get auto-complete.
     *
     * @param mixed $presentable Whatever needs to be presented
     *
     * @return array
     */
    protected function presentSingle($presentable)
    {
        return [
            'a' => 1,
            'b' => 2,
        ];
    }

    /**
     * @param mixed $presentable
     *
     * @return mixed
     */
    protected function presentSingleInline($presentable)
    {
        return 1;
    }
}