<?php

declare(strict_types=1);

namespace IssetBV\Presenter\Exception;

use Exception;

/**
 * Class PresenterException.
 */
class PresenterException extends Exception
{
    /**
     * @param string $message
     */
    public function __construct($message)
    {
        parent::__construct($message);
    }

    public static function createTypeException($type, $caller)
    {
        $typeValue = is_object($type)
            ? get_class($type)
            : gettype($type);

        return new PresenterException($typeValue . ' not supported by ' . get_class($caller));
    }
}
