Read Me
=======

### Example

```php
<?php

namespace MyNamespace;

use IssetBV\Presenter\PresenterAdapter;

class MyPresenter extends PresenterAdapter
{
    public function supports($presentable): bool
    {
        return $presentable instanceof MyEntity;
    }
    
    protected function presentSingle($presentable)
    {
        return [
            'id' => $presentable->getId(),
            'status' => $presentable->getStatus(),
            'dateValidUntil' => $presentable->getDateValidUntil()->format('c'),
        ];
    }
    
    protected function presentSingleInline($presentable)
    {
        return $presentable->getId();
    }
}
```