<?php

namespace IssetBV\Core\PresenterBundle\Presenter;

use IssetBV\Core\PresenterBundle\Exception\PresenterException;

/**
 * Interface PresenterInterface.
 *
 * @author Tim Fennis <tim@isset.nl>
 */
interface Presenter
{
    /**
     * Converts a collection of data to an encodable array or value.
     *
     * @param mixed $presentable
     *
     * @throws PresenterException
     *
     * @return string|int|array
     */
    public function present($presentable);

    /**
     * @param callable $closure
     */
    public function registerClosure(callable $closure);

    /**
     * @param mixed $presentable
     *
     * @return bool
     */
    public function supports($presentable) : bool;

    /**
     * Map a presenter to a child property.
     *
     * @param string $childName
     * @param Presenter $presenter
     * @param string $overrideKey
     */
    public function mapChildPresenter(string $childName, Presenter $presenter, string $overrideKey = null);

    /**
     * @param callable $keyConverter
     */
    public function setKeyConverter(callable $keyConverter);
}
