<?php
/**
 * Created by PhpStorm.
 * User: tim
 * Date: 6-8-14
 * Time: 11:07
 */

namespace IssetBV\Core\PresenterBundle\Presenter;

use Closure;
use IssetBV\Core\PresenterBundle\Converter\KeyConverterInterface;
use IssetBV\Core\PresenterBundle\Exception\PresenterException;

interface PresenterInterface
{
    /**
     * Converts a collection of data to an encodable array or value
     *
     * @param \Traversable|array $collection
     * @return string|int|array
     * @throws PresenterException
     */
    public function present($collection);

    /**
     * @param mixed $object
     * @return string|int|array
     * @throws PresenterException
     */
    public function presentSingle($object);

    /**
     * Map a presenter to a child property
     *
     * @param string $childName
     * @param PresenterInterface $presenter
     * @param string $overrideKey
     * @return void
     */
    public function mapChildPresenter($childName, PresenterInterface $presenter, $overrideKey = null);

    /**
     * Tell this presenter to inline it's value
     *
     * @param boolean $inline
     * @return void
     */
    public function setInline($inline);

    /**
     * @param Closure $keyConverter
     * @return void
     */
    public function setKeyConverter(Closure $keyConverter);

    /**
     * @return Closure
     */
    public function getKeyConverter();

    /**
     * @param boolean $inject
     * @return void
     */
    public function setInjectKeyConverterInChildPresenters($inject);

    /**
     * @param boolean $restore
     * @return void
     */
    public function setRestoreKeyConverterInChildPresenters($restore);
}