<?php

namespace Placer\Config;

class TpcConfig {
	
	protected $api_url;
	protected $api_key;
	protected $api_secret;
	protected $cache_path;
	
	public function __construct($api_url, $api_key, $api_secret, $cache_path = '')
	{
		$this->api_url    = $api_url;
		$this->api_key    = $api_key;
		$this->api_secret = $api_secret;
		$this->cache_path = $cache_path;
	}

	public function getApiUrl() 
	{
		return $this->api_url;
	}

	public function getApiKey()
	{
		return $this->api_key;
	}

	public function getApiSecret()
	{
		return $this->api_secret;
	}

	public function getCachePath()
	{
		return $this->cache_path;
	}
	
	public static function createFromArray($config)
	{
		$required = array('api_url', 'api_key', 'api_secret');
		foreach ($required as $key) {
			if (FALSE === array_key_exists($key, $config)) {
				throw new \InvalidArgumentException('Missing param ' . $key);
			}
		}
		
		$cache_path = isset($config['cache_path']) ? $config['cache_path'] : '';
		
		return new static($config['api_url'], $config['api_key'], $config['api_secret'], $cache_path);
	}
}