<?php

namespace Placer\Client;

use Placer\LoggerInterface;
use Placer\Config\TpcConfig;
use Placer\PlacingData\RegisterPlacingDataInterface;
use Tpc\Tpc;


class TpcClient {

	/*
	 * @var $client \Tpc\Tpc
	 */
	protected $client;

	protected $id_prefix;
	protected $callback_url;
	protected $logger;
    protected $messages;

	public function __construct(TpcConfig $config, LoggerInterface $logger)
	{
		if (count($config) > 0)
		{
			$this->initialize($config);
		}

		$this->logger = $logger;
		$this->client = new Tpc($config->getApiUrl(), $config->getApiKey(), $config->getApiSecret(), $config->getCachePath());
	}

	/**
	 * Initiliaze config settings
	 *
	 * @param array $config
	 */
	public function initialize($config = array())
	{
		foreach ($config as $key => $val)
		{
			if (property_exists($this, $key))
			{
				$this->$key = $val;
			}
		}
	}

	/**
	 * Request status of a placing
	 *
	 * @param string $id
	 * @return
	 */
	public function getById($id)
	{
		$payload = $this->client->createJobStatusPayload($id);

		return $this->client->sendPayload($payload);
	}

	/**
	 * Register a new placing
	 *
	 * @param RegisterPlacingDataInterface $data
	 * @return type
	 */
	public function register(RegisterPlacingDataInterface $data)
	{
		$payload = $this->client->createJobAddPayload($data->getPublishProfile(), $data->getCallbackUrl());
		$payload->setPostData('file', $data->getId());
		$payload->setPostData('audio_locale', $data->getAudioLanguages());
		$payload->setPostData('subtitle_locale', $data->getSubtitleLanguages());
		$payload->setPostData('meta', $data->getMetaData());

		try
		{
			return $this->client->sendPayload($payload);
		}
		catch (\Exception $e)
		{
			$this->_set_message($e->getMessage());
			$this->logger->addError($e->getMessage());
			return false;
		}
	}

	public function update($data)
	{
		return false;
	}

	protected function _set_message($messages)
	{
		$this->messages .= $messages;
	}

	public function get_messages()
	{
		return $this->messages;
	}

}
